/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationSolution;

import java.util.List;
import static salesApplicationSolution.TestPriceList.createDemoPriceList;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class InvestigatingPolymorphism {

    public static void main(String[] args) {
        
        //Testing ploymorphism
        Ruler myRuler = new Ruler("Plastic Ruler.", "This is a durable long lasting plastic ruler.", 1.00, "30cm");
        Product myProduct = myRuler;
        myRuler.setPrice(5.0);
        System.out.println("Price: " + myProduct.getPrice());

        //Testing to see what kind of product we have
        if (myProduct instanceof Ruler){
            System.out.println("This product is a ruler.");
            Ruler aRuler = (Ruler) myProduct;
            System.out.println("The length of this ruler is "+aRuler.getLength());
        }
        
        //Be careful with casting
//        Pen aPen = (Pen) myProduct;
//        System.out.println("The type of pen is "+aPen.type);
        
        //Always test for compatibility first
        if (myProduct instanceof Pen){
            Pen aPen = (Pen) myProduct;
            System.out.println("The type of pen is "+aPen.type);
        }
        
        //If our methods are overriden, which one will run
        myProduct.printProduct();
        
    }

}
